
<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $conn = new mysqli("localhost", "primaria_dental", "Olympics@2028", "primaria_dental");

    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    function clean($conn, $data) {
        return $conn->real_escape_string(trim($data));
    }

    $patient_id = clean($conn, $_POST['patient_id']);
    $first_name = clean($conn, $_POST['first_name']);
    $last_name = clean($conn, $_POST['last_name']);
    $dob = clean($conn, $_POST['dob']);
    $age = (int)$_POST['age'];
    $gender = clean($conn, $_POST['gender']);
    $marital_status = clean($conn, $_POST['marital_status']);
    $phone = clean($conn, $_POST['phone']);
    $email = clean($conn, $_POST['email']);
    $address = clean($conn, $_POST['address']);
    $city_state_zip = clean($conn, $_POST['city_state_zip']);
    $emergency_contact_name = clean($conn, $_POST['emergency_contact_name']);
    $emergency_contact_number = clean($conn, $_POST['emergency_contact_number']);
    $relationship_to_patient = clean($conn, $_POST['relationship_to_patient']);
    $insurance_provider = clean($conn, $_POST['insurance_provider']);
    $policy_number = clean($conn, $_POST['policy_number']);
    $complaint_description = clean($conn, $_POST['complaint_description']);
    $onset = clean($conn, $_POST['onset']);
    $duration = clean($conn, $_POST['duration']);
    $pain_level = (int)$_POST['pain_level'];
    $aggravating_factors = clean($conn, $_POST['aggravating_factors']);
    $medical_history = isset($_POST['medical_history']) ? implode(", ", $_POST['medical_history']) : '';
    $medical_notes = clean($conn, $_POST['medical_notes']);
    $taking_medications = clean($conn, $_POST['taking_medications']);
    $medications = clean($conn, $_POST['medications']);
    $has_allergies = clean($conn, $_POST['has_allergies']);
    $allergy_details = clean($conn, $_POST['allergy_details']);
    $first_dental_visit = clean($conn, $_POST['first_dental_visit']);
    $past_dental_experience = clean($conn, $_POST['past_dental_experience']);
    $tobacco_use = clean($conn, $_POST['tobacco_use']);
    $alcohol_use = clean($conn, $_POST['alcohol_use']);
    $radiographs = clean($conn, $_POST['radiographs']);
    $xray_teeth = clean($conn, $_POST['xray_teeth']);

    $intraoral_photo = "";
    if (isset($_FILES['intraoral_photo']) && $_FILES['intraoral_photo']['error'] == 0) {
        $target_dir = "uploads/";
        if (!file_exists($target_dir)) mkdir($target_dir);
        $intraoral_photo = $target_dir . basename($_FILES["intraoral_photo"]["name"]);
        move_uploaded_file($_FILES["intraoral_photo"]["tmp_name"], $intraoral_photo);
    }

    $diagnosis = clean($conn, $_POST['diagnosis']);
    $treatment_plan = clean($conn, $_POST['treatment_plan']);
    $consent_given = clean($conn, $_POST['consent_given']);
    $next_appointment = clean($conn, $_POST['next_appointment']);
    $patient_signature = clean($conn, $_POST['patient_signature']);
    $dentist_name = clean($conn, $_POST['dentist_name']);
    $dentist_signature = clean($conn, $_POST['dentist_signature']);
    $record_date = clean($conn, $_POST['record_date']);

    $sql = "INSERT INTO patient_records (
        patient_id, first_name, last_name, dob, age, gender, marital_status, phone, email, address,
        city_state_zip, emergency_contact_name, emergency_contact_number, relationship_to_patient,
        insurance_provider, policy_number, complaint_description, onset, duration, pain_level,
        aggravating_factors, medical_history, medical_notes, taking_medications, medications,
        has_allergies, allergy_details, first_dental_visit, past_dental_experience, tobacco_use,
        alcohol_use, radiographs, xray_teeth, intraoral_photo, diagnosis, treatment_plan,
        consent_given, next_appointment, patient_signature, dentist_name, dentist_signature,
        record_date
    ) VALUES (
        '$patient_id', '$first_name', '$last_name', '$dob', $age, '$gender', '$marital_status',
        '$phone', '$email', '$address', '$city_state_zip', '$emergency_contact_name',
        '$emergency_contact_number', '$relationship_to_patient', '$insurance_provider',
        '$policy_number', '$complaint_description', '$onset', '$duration', $pain_level,
        '$aggravating_factors', '$medical_history', '$medical_notes', '$taking_medications',
        '$medications', '$has_allergies', '$allergy_details', '$first_dental_visit',
        '$past_dental_experience', '$tobacco_use', '$alcohol_use', '$radiographs', '$xray_teeth',
        '$intraoral_photo', '$diagnosis', '$treatment_plan', '$consent_given', '$next_appointment',
        '$patient_signature', '$dentist_name', '$dentist_signature', '$record_date'
    )";

    if ($conn->query($sql) === TRUE) {
        echo "<script>alert('Record submitted successfully'); window.location.href='form.php';</script>";
    } else {
        echo "Error: " . $conn->error;
    }

    $conn->close();
}
?>

<!-- Include your HTML form here -->
<!-- For simplicity, reuse the form previously provided -->
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Primaria Dental – Patient Clinical Record</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      padding: 20px;
      background-color: #f9f9f9;
    }
    h2 {
      color: #2c3e50;
    }
    form {
      background: #fff;
      padding: 20px;
      border-radius: 8px;
      max-width: 900px;
      margin: auto;
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    fieldset {
      margin-bottom: 20px;
      border: 1px solid #ccc;
      padding: 15px;
      border-radius: 5px;
    }
    legend {
      font-weight: bold;
      padding: 0 10px;
    }
    label {
      display: block;
      margin-top: 10px;
      font-weight: bold;
    }
    input, select, textarea {
      width: 100%;
      padding: 8px;
      margin-top: 5px;
      border-radius: 4px;
      border: 1px solid #ccc;
    }
    .row {
      display: flex;
      gap: 20px;
      flex-wrap: wrap;
    }
    .col {
      flex: 1;
      min-width: 200px;
    }
    .checkbox-group {
      display: flex;
      flex-direction: column;
    }
    .submit-btn {
      background-color: #3498db;
      color: white;
      border: none;
      padding: 12px 20px;
      cursor: pointer;
      font-size: 16px;
      border-radius: 5px;
    }
  </style>
</head>
<body>

  <form>
    <h2>Primaria Dental – Patient Clinical Record</h2>

    <!-- 1. Demographic Details -->
    <fieldset>
      <legend>🦷 1. Patient Demographic Details</legend>
      <div class="row">
        <div class="col"><label>Patient ID</label><input type="text"></div>
        <div class="col"><label>First Name</label><input type="text"></div>
        <div class="col"><label>Last Name</label><input type="text"></div>
        <div class="col"><label>Date of Birth</label><input type="date"></div>
        <div class="col"><label>Age (Auto-calculated)</label><input type="number"></div>
        <div class="col"><label>Gender</label><select><option>Male</option><option>Female</option></select></div>
        <div class="col"><label>Marital Status</label><select><option>Single</option><option>Married</option></select></div>
        <div class="col"><label>Phone Number</label><input type="tel"></div>
        <div class="col"><label>Email Address</label><input type="email"></div>
        <div class="col"><label>Address</label><textarea rows="2"></textarea></div>
        <div class="col"><label>City / State / ZIP</label><input type="text"></div>
        <div class="col"><label>Emergency Contact Name</label><input type="text"></div>
        <div class="col"><label>Emergency Contact Number</label><input type="tel"></div>
        <div class="col"><label>Relationship to Patient</label><input type="text"></div>
        <div class="col"><label>Insurance Provider</label><input type="text"></div>
        <div class="col"><label>Policy Number</label><input type="text"></div>
      </div>
    </fieldset>

    <!-- 2. Chief Complaint -->
    <fieldset>
      <legend>🦷 2. Chief Complaint</legend>
      <label>Description of Complaint</label><input type="text">
      <label>Onset</label><input type="text">
      <label>Duration</label><input type="text">
      <label>Pain Level (1–10)</label><input type="number" min="1" max="10">
      <label>Aggravating/Relieving Factors</label><input type="text">
    </fieldset>

    <!-- 3. General Medical History -->
    <fieldset>
      <legend>🦷 3. General Medical History</legend>
      <div class="checkbox-group">
        <label>Heart Disease / Heart Attack <input type="checkbox"></label>
        <label>High Blood Pressure <input type="checkbox"></label>
        <label>Diabetes (Type I or II) <input type="checkbox"></label>
        <label>Asthma or Breathing Problems <input type="checkbox"></label>
        <label>Allergies (List Below) <input type="checkbox"></label>
        <label>Bleeding or Blood Disorders <input type="checkbox"></label>
        <label>Hepatitis (A, B, or C) <input type="checkbox"></label>
        <label>HIV / AIDS <input type="checkbox"></label>
        <label>Kidney Disease <input type="checkbox"></label>
        <label>Liver Disease <input type="checkbox"></label>
        <label>Seizures / Epilepsy <input type="checkbox"></label>
        <label>Thyroid Disorders <input type="checkbox"></label>
        <label>Cancer (Type below) <input type="checkbox"></label>
        <label>Osteoporosis <input type="checkbox"></label>
        <label>Arthritis or Joint Issues <input type="checkbox"></label>
        <label>Artificial Joints or Implants <input type="checkbox"></label>
        <label>Psychiatric / Mental Health Issues <input type="checkbox"></label>
        <label>Other (Specify below) <input type="checkbox"></label>
      </div>
      <label>Allergy Notes / Cancer Type / Other Conditions</label>
      <textarea rows="3"></textarea>
    </fieldset>

    <!-- 4. Current Medications -->
    <fieldset>
      <legend>🦷 4. Current Medications</legend>
      <label>Are you taking any medications? <select><option>Yes</option><option>No</option></select></label>
      <label>List Medications</label>
      <textarea rows="3" placeholder="1. \n2. \n3. "></textarea>
    </fieldset>

    <!-- 5. Allergies -->
    <fieldset>
      <legend>🦷 5. Allergies</legend>
      <label>Do you have any known allergies? <select><option>Yes</option><option>No</option></select></label>
      <label>If yes, list them</label>
      <textarea rows="2"></textarea>
    </fieldset>

    <!-- 6. Past Dental History -->
    <fieldset>
      <legend>🦷 6. Past Dental History</legend>
      <label>Is this your first dental visit? <select><option>Yes</option><option>No</option></select></label>
      <label>Past dental experience</label><textarea rows="2"></textarea>
      <label>Do you use tobacco? <select><option>Yes</option><option>No</option></select></label>
      <label>Do you consume alcohol? <select><option>Yes</option><option>No</option></select></label>
    </fieldset>

    <!-- 7. Investigations -->
    <fieldset>
      <legend>🦷 7. Investigations</legend>
      <label>Radiographs / X-rays Description</label><input type="text">
      <label>If X-ray, specify tooth number</label><input type="text">
      <label>Upload Intraoral Photos</label><input type="file" accept="image/*">
    </fieldset>

    <!-- 8. Diagnosis -->
    <fieldset>
      <legend>🦷 8. Diagnosis</legend>
      <textarea rows="3" placeholder="e.g., Chronic Apical Periodontitis Tooth #46, Dental Caries Tooth #14, #15"></textarea>
    </fieldset>

    <!-- 9. Treatment Plan -->
    <fieldset>
      <legend>🦷 9. Treatment Plan</legend>
      <label>Stepwise Procedures and Notes</label>
      <textarea rows="4" placeholder="1. Root Canal Treatment (RCT) - #46 - Due to infection
2. Restoration - #14, #15 - Post-caries removal
3. Oral Prophylaxis - Full Mouth - To maintain hygiene"></textarea>
    </fieldset>

    <!-- 10. Consent & Follow-up -->
    <fieldset>
      <legend>✅ 10. Consent & Follow-up</legend>
      <label>Informed Consent Taken <select><option>Yes</option><option>No</option></select></label>
      <label>Next Appointment Date</label><input type="date">
      <label>Patient Signature</label><input type="text">
      <label>Dentist Name</label><input type="text">
      <label>Dentist Signature</label><input type="text">
      <label>Date of Record Entry</label><input type="date">
    </fieldset>

    <button type="submit" class="submit-btn">Submit Form</button>
  </form>

</body>
</html>
