<?php
require_once '../db/config.php';

$message = "";
if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $staff_name       = $_POST['staff_name'];
  $period           = $_POST['period'];
  $revenue_generated = $_POST['revenue_generated'];
  $revenue_source   = $_POST['revenue_source'];
  $payment_status   = $_POST['payment_status'];
  $commission       = $_POST['commission'];
  $remarks          = $_POST['remarks'];

  $sql = "INSERT INTO staff_revenue (staff_name, period, revenue_generated, revenue_source, payment_status, commission, remarks)
          VALUES (?, ?, ?, ?, ?, ?, ?)";

  $stmt = $conn->prepare($sql);
  $stmt->bind_param("ssdssds", $staff_name, $period, $revenue_generated, $revenue_source, $payment_status, $commission, $remarks);

  if ($stmt->execute()) {
    $message = "✅ Revenue entry submitted successfully.";
  } else {
    $message = "❌ Error: " . $stmt->error;
  }

  $stmt->close();
  $conn->close();
}
?>

<!DOCTYPE html>
<html>
<head>
  <title>Staff Revenue Entry</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f4f4f4;
      padding: 30px;
    }
    .form-container {
      background: white;
      max-width: 650px;
      margin: auto;
      padding: 25px;
      border-radius: 10px;
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    h2 {
      text-align: center;
      color: #2c3e50;
    }
    label {
      margin-top: 15px;
      display: block;
    }
    input, select, textarea {
      width: 100%;
      padding: 10px;
      margin-top: 5px;
      border-radius: 5px;
      border: 1px solid #ccc;
    }
    textarea {
      height: 80px;
      resize: vertical;
    }
    button {
      margin-top: 20px;
      padding: 12px;
      width: 100%;
      background-color: #2c3e50;
      color: white;
      border: none;
      font-size: 16px;
      border-radius: 5px;
      cursor: pointer;
    }
    .message {
      text-align: center;
      color: green;
      font-weight: bold;
      margin-top: 15px;
    }
  </style>
</head>
<body>
  <div class="form-container">
    <h2>Staff Revenue Entry</h2>
    <?php if ($message): ?>
      <p class="message"><?php echo $message; ?></p>
    <?php endif; ?>
    <form method="POST">
      <label>Staff Name</label>
      <input type="text" name="staff_name" required>

      <label>Period (Month / Year)</label>
      <input type="month" name="period" required>

      <label>Revenue Generated (₹)</label>
      <input type="number" name="revenue_generated" step="0.01" required>

      <label>Revenue Source</label>
      <input type="text" name="revenue_source" required>

      <label>Payment Status</label>
      <select name="payment_status" required>
        <option value="">-- Select --</option>
        <option value="Paid">Paid</option>
        <option value="Pending">Pending</option>
      </select>

      <label>Commission/incentives</label>
      <input type="number" name="commission" step="0.01" required>

      <label>Remarks</label>
      <textarea name="remarks" placeholder="Additional notes or comments..."></textarea>

      <button type="submit">Submit</button>
    </form>
  </div>
</body>
</html>
