<?php
require_once '../db/config.php';

$success = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $date            = $_POST['date'];
  $camp_name       = $_POST['camp_name'];
  $tasks_performed = $_POST['tasks_performed'];
  $hours_worked    = $_POST['hours_worked'];
  $patients        = $_POST['patients_attended'];
  $notes           = $_POST['notes'];

  $sql = "INSERT INTO daily_work (date, camp_name, tasks_performed, hours_worked, patients_attended, notes)
          VALUES (?, ?, ?, ?, ?, ?)";

  $stmt = $conn->prepare($sql);
  $stmt->bind_param("sssdis", $date, $camp_name, $tasks_performed, $hours_worked, $patients, $notes);

  if ($stmt->execute()) {
    $success = "✔️ Daily work update submitted successfully!";
  } else {
    $success = "❌ Error: " . $stmt->error;
  }

  $stmt->close();
  $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Daily Work Update</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f8f8f8;
      padding: 20px;
    }
    .form-container {
      max-width: 600px;
      background: white;
      padding: 25px;
      margin: auto;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    h2 {
      text-align: center;
      margin-bottom: 20px;
    }
    label {
      display: block;
      margin-top: 15px;
    }
    input, textarea {
      width: 100%;
      padding: 10px;
      margin-top: 5px;
      border: 1px solid #ccc;
      border-radius: 5px;
    }
    textarea {
      resize: vertical;
      height: 100px;
    }
    button {
      margin-top: 20px;
      width: 100%;
      padding: 12px;
      background-color: #2c3e50;
      color: white;
      border: none;
      border-radius: 5px;
      font-size: 16px;
    }
    .message {
      text-align: center;
      margin-top: 15px;
      font-weight: bold;
      color: green;
    }
  </style>
</head>
<body>
  <div class="form-container">
    <h2>Daily Work Update</h2>
    <?php if ($success): ?>
      <p class="message"><?php echo $success; ?></p>
    <?php endif; ?>
    <form method="POST">
      <label>Date</label>
      <input type="date" name="date" required>

      <label>Camp Name/location</label>
      <input type="text" name="camp_name" required>

      <label>Tasks Performed</label>
      <div class="checkbox-group">
        <label><input type="checkbox" name="tasks_performed" value="Screening"> Screening</label>
        <label><input type="checkbox" name="tasks_performed" value="Treatment"> Treatment</label>
        <label><input type="checkbox" name="tasks_performed" value="Documentation"> Documentation</label>
      </div>

      <label>Hours Worked</label>
      <input type="number" name="hours_worked" step="0.1" required>

      <label>Patients Attended</label>
      <input type="number" name="patients_attended" required>

      <label>Notes</label>
      <textarea name="notes" placeholder="Enter any additional observations or notes..."></textarea>

      <button type="submit">Submit</button>
    </form>
  </div>
</body>
</html>
