<?php
require_once '../db/config.php';

$success = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $camp_name   = $_POST['camp_name'];
  $camp_date   = $_POST['camp_date'];
  $patients    = $_POST['patients_screened'];
  $other_duties = $_POST['other_duties'];
  $remarks     = $_POST['remarks'];

  $sql = "INSERT INTO camp_performance (camp_name, camp_date, patients_screened, other_duties, remarks)
          VALUES (?, ?, ?, ?, ?)";

  $stmt = $conn->prepare($sql);
  $stmt->bind_param("ssiss", $camp_name, $camp_date, $patients, $other_duties, $remarks);

  if ($stmt->execute()) {
    $success = "✔️ Camp performance record submitted successfully!";
  } else {
    $success = "❌ Error: " . $stmt->error;
  }

  $stmt->close();
  $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Camp Performance Form</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f8f8f8;
      padding: 20px;
    }
    .form-container {
      max-width: 600px;
      margin: auto;
      background: white;
      padding: 25px;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    h2 {
      text-align: center;
    }
    label {
      margin-top: 15px;
      display: block;
    }
    input, textarea {
      width: 100%;
      padding: 10px;
      margin-top: 5px;
      border: 1px solid #ccc;
      border-radius: 5px;
    }
    textarea {
      resize: vertical;
      height: 120px;
    }
    button {
      margin-top: 20px;
      width: 100%;
      padding: 12px;
      background-color: #2c3e50;
      color: white;
      border: none;
      font-size: 16px;
      border-radius: 5px;
    }
    .message {
      text-align: center;
      margin-top: 15px;
      font-weight: bold;
      color: green;
    }
  </style>
</head>
<body>
  <div class="form-container">
    <h2>Camp Performance Form</h2>
    <?php if ($success): ?>
      <p class="message"><?php echo $success; ?></p>
    <?php endif; ?>
    <form method="POST">
      <label>Camp Name</label>
      <input type="text" name="camp_name" required>

      <label>Camp Date</label>
      <input type="date" name="camp_date" required>

      <label>Patients Screened</label>
      <input type="number" name="patients_screened" required>

      <label>Other Duties Performed</label>
      <input type="text" name="other_duties" placeholder="e.g., Coordination, Registration, Setup..." required>

      <label>Remarks</label>
      <textarea name="remarks" placeholder="Enter detailed remarks or observations..."></textarea>

      <button type="submit">Submit</button>
    </form>
  </div>
</body>
</html>
