<?php
require_once '../db/config.php';

$message = "";
if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $hospital_name = $_POST['hospital_name'];
  $business_type = $_POST['business_type'];
  $materials     = isset($_POST['materials_supplied']) ? implode(", ", $_POST['materials_supplied']) : '';
  $equipment     = $_POST['equipment_supplied'];
  $transaction_date = $_POST['transaction_date'];
  $amount        = $_POST['amount'];
  $remarks       = $_POST['remarks'];

  $sql = "INSERT INTO business_network (hospital_name, business_type, materials_supplied, equipment_supplied, transaction_date, amount, remarks)
          VALUES (?, ?, ?, ?, ?, ?, ?)";

  $stmt = $conn->prepare($sql);
  $stmt->bind_param("sssssss", $hospital_name, $business_type, $materials, $equipment, $transaction_date, $amount, $remarks);

  if ($stmt->execute()) {
    $message = "✅ Business network entry submitted successfully.";
  } else {
    $message = "❌ Error: " . $stmt->error;
  }

  $stmt->close();
  $conn->close();
}
?>

<!DOCTYPE html>
<html>
<head>
  <title>Business Network Form</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f3f3f3;
      padding: 20px;
    }
    .form-container {
      max-width: 650px;
      margin: auto;
      background: white;
      padding: 25px;
      border-radius: 10px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }
    h2 {
      text-align: center;
    }
    label {
      display: block;
      margin-top: 15px;
    }
    input[type="text"],
    input[type="date"],
    input[type="number"],
    select,
    textarea {
      width: 100%;
      padding: 10px;
      margin-top: 6px;
      border: 1px solid #ccc;
      border-radius: 5px;
    }
    .checkbox-group {
      margin-top: 10px;
    }
    .checkbox-group label {
      display: inline-block;
      margin-right: 15px;
    }
    textarea {
      resize: vertical;
      height: 80px;
    }
    button {
      margin-top: 20px;
      width: 100%;
      background-color: #2c3e50;
      color: white;
      padding: 12px;
      border: none;
      border-radius: 5px;
      font-size: 16px;
    }
    .message {
      text-align: center;
      color: green;
      margin-top: 15px;
      font-weight: bold;
    }
  </style>
</head>
<body>
  <div class="form-container">
    <h2>Business Network Entry</h2>
    <?php if ($message): ?>
      <p class="message"><?php echo $message; ?></p>
    <?php endif; ?>
    <form method="POST">
      <label>Hospital Name</label>
      <input type="text" name="hospital_name" required>

      <label>Business Type</label>
      <select name="business_type" required>
        <option value="">-- Select --</option>
        <option value="Referral">Referral</option>
        <option value="Supplies">Supplies</option>
        <option value="Consultation">Consultation</option>
      </select>

      <label>Materials Supplied</label>
      <div class="checkbox-group">
        <label><input type="checkbox" name="materials_supplied[]" value="Dental Implants"> Dental Implants</label>
        <label><input type="checkbox" name="materials_supplied[]" value="Gloves"> Gloves</label>
      </div>

      <label>Equipment Supplied</label>
      <input type="text" name="equipment_supplied" placeholder="Optional">

      <label>Date of Business Transaction</label>
      <input type="date" name="transaction_date" required>

      <label>Amount (₹)</label>
      <input type="number" name="amount" step="0.01" required>

      <label>Remarks</label>
      <textarea name="remarks" placeholder="Additional details or notes..."></textarea>

      <button type="submit">Submit</button>
    </form>
  </div>
</body>
</html>
