<?php
include __DIR__ . '/../db/config.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
  $stmt = $conn->prepare(
    "INSERT INTO teleconsultations (
      consultation_id, consult_date, consult_time, dentist_name, doctor_location, consult_mode,
      patient_name, age, gender, contact, patient_location,
      chief_complaint, findings, treatment, referral_needed, referred_to,
      converted, appointment_date, procedure_done, revenue, feedback
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"
  );

  $stmt->bind_param(
    "sssssssssssssssssssss",
    $_POST['consultation_id'],
    $_POST['consult_date'],
    $_POST['consult_time'],
    $_POST['dentist_name'],
    $_POST['doctor_location'],
    $_POST['consult_mode'],
    $_POST['patient_name'],
    $_POST['age'],
    $_POST['gender'],
    $_POST['contact'],
    $_POST['patient_location'],
    $_POST['chief_complaint'],
    $_POST['findings'],
    $_POST['treatment'],
    $_POST['referral_needed'],
    $_POST['referred_to'],
    $_POST['converted'],
    $_POST['appointment_date'],
    $_POST['procedure_done'],
    $_POST['revenue'],
    $_POST['feedback']
  );

  $message = $stmt->execute()
    ? "✅ Teleconsultation submitted successfully!"
    : "❌ Error: " . $stmt->error;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Primaria Dental Teleconsultation Form</title>
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
  <style>
    body { padding: 20px; background-color: #f9f9f9; }
    .section-title { margin-top: 30px; font-weight: bold; }
    .form-group label { font-weight: 500; }
  </style>
</head>
<body>
<div class="container">
  <h3>🦷 Teleconsultation Entry Form</h3>
  <?php if (isset($message)): ?>
    <div class="alert alert-info"><?= $message ?></div>
  <?php endif; ?>

  <form method="post">
    <!-- 1. Teleconsultation Session Details -->
    <div class="section-title">📅 1. Teleconsultation Session Details</div>
    <div class="form-row">
      <div class="form-group col-md-4">
        <label>Consultation ID</label>
        <input type="text" class="form-control" name="consultation_id" required>
      </div>
      <div class="form-group col-md-4">
        <label>Date of Teleconsultation</label>
        <input type="date" class="form-control" name="consult_date" required>
      </div>
      <div class="form-group col-md-4">
        <label>Time</label>
        <input type="time" class="form-control" name="consult_time" required>
      </div>
    </div>
    <div class="form-row">
      <div class="form-group col-md-6">
        <label>Dentist Name</label>
        <input type="text" class="form-control" name="dentist_name">
      </div>
      <div class="form-group col-md-6">
        <label>Location (Doctor)</label>
        <input type="text" class="form-control" name="doctor_location">
      </div>
    </div>
    <div class="form-group">
      <label>Mode of Teleconsultation</label>
      <select class="form-control" name="consult_mode">
        <option value="">--Select--</option>
        <option value="Phone">Phone</option>
        <option value="WhatsApp Chat">WhatsApp Chat</option>
      </select>
    </div>

    <!-- 2. Patient Information -->
    <div class="section-title">👤 2. Patient Information</div>
    <div class="form-row">
      <div class="form-group col-md-6">
        <label>Patient Name</label>
        <input type="text" class="form-control" name="patient_name">
      </div>
      <div class="form-group col-md-2">
        <label>Age</label>
        <input type="number" class="form-control" name="age">
      </div>
      <div class="form-group col-md-4">
        <label>Gender</label>
        <select class="form-control" name="gender">
          <option value="">--Select--</option>
          <option>Male</option>
          <option>Female</option>
          <option>Other</option>
        </select>
      </div>
    </div>
    <div class="form-row">
      <div class="form-group col-md-6">
        <label>Contact Number</label>
        <input type="text" class="form-control" name="contact">
      </div>
      <div class="form-group col-md-6">
        <label>Location (Patient)</label>
        <input type="text" class="form-control" name="patient_location">
      </div>
    </div>

    <!-- 3. Consultation Details -->
    <div class="section-title">📝 3. Consultation Details</div>
    <div class="form-group">
      <label>Chief Complaint</label>
      <input type="text" class="form-control" name="chief_complaint">
    </div>
    <div class="form-group">
      <label>Findings (Preliminary)</label>
      <textarea class="form-control" name="findings" rows="2"></textarea>
    </div>
    <div class="form-group">
      <label>Recommended Treatment</label>
      <textarea class="form-control" name="treatment" rows="2"></textarea>
    </div>
    <div class="form-row">
      <div class="form-group col-md-4">
        <label>Referral Needed?</label>
        <select class="form-control" name="referral_needed">
          <option value="">--Select--</option>
          <option>Yes</option>
          <option>No</option>
        </select>
      </div>
      <div class="form-group col-md-8">
        <label>Referred to (Clinic/Hospital)</label>
        <input type="text" class="form-control" name="referred_to">
      </div>
    </div>

    <!-- 4. Conversion Tracking -->
    <div class="section-title">✅ 4. Conversion Tracking</div>
    <div class="form-group">
      <label>Did Patient Convert to In-Person?</label>
      <select class="form-control" name="converted">
        <option value="">--Select--</option>
        <option>Yes</option>
        <option>No</option>
      </select>
    </div>
    <div class="form-row">
      <div class="form-group col-md-4">
        <label>Date of Appointment</label>
        <input type="date" class="form-control" name="appointment_date">
      </div>
      <div class="form-group col-md-4">
        <label>Procedure Done</label>
        <input type="text" class="form-control" name="procedure_done">
      </div>
      <div class="form-group col-md-4">
        <label>Revenue from Conversion (₹)</label>
        <input type="number" class="form-control" name="revenue">
      </div>
    </div>
    <div class="form-group">
      <label>Feedback from Patient</label>
      <textarea class="form-control" name="feedback" rows="2"></textarea>
    </div>

    <button type="submit" class="btn btn-primary mt-3">Submit</button>
  </form>
</div>
</body>
</html>
