<?php
// Enable full error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ✅ Include the config file correctly
require_once '../db/config.php';

$success = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $staff_id   = $_POST['staff_id'];
  $full_name  = $_POST['full_name'];
  $role       = $_POST['role'];
  $department = $_POST['department'];
  $contact    = $_POST['contact'];
  $email      = $_POST['email'];
  $doj        = $_POST['doj'];
  $location   = $_POST['location'];
  $salary     = $_POST['salary'];

  $sql = "INSERT INTO staff_entry (staff_id, full_name, role, department, contact, email, date_of_joining, location, salary)
          VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
  $stmt = $conn->prepare($sql);

  if ($stmt) {
    $stmt->bind_param("ssssssssd", $staff_id, $full_name, $role, $department, $contact, $email, $doj, $location, $salary);
    if ($stmt->execute()) {
      $success = "✔️ Staff record saved successfully!";
    } else {
      $success = "❌ Execute error: " . $stmt->error;
    }
    $stmt->close();
  } else {
    $success = "❌ Prepare error: " . $conn->error;
  }

  $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Staff Personal Details Form</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f0f0f0;
      padding: 20px;
    }
    .form-container {
      max-width: 600px;
      margin: auto;
      background: white;
      padding: 30px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      border-radius: 10px;
    }
    h2 {
      text-align: center;
      margin-bottom: 20px;
    }
    label {
      display: block;
      margin-top: 15px;
    }
    input, select {
      width: 100%;
      padding: 10px;
      margin-top: 5px;
      border: 1px solid #ccc;
      border-radius: 5px;
    }
    button {
      margin-top: 20px;
      width: 100%;
      padding: 12px;
      background: #2c3e50;
      color: white;
      border: none;
      border-radius: 5px;
      font-size: 16px;
    }
    .message {
      text-align: center;
      margin-top: 15px;
      font-weight: bold;
      color: green;
    }
    .message.error {
      color: red;
    }
  </style>
</head>
<body>
  <div class="form-container">
    <h2>Staff Personal Details</h2>
    <?php if ($success): ?>
      <p class="message <?php echo (str_starts_with($success, '❌')) ? 'error' : ''; ?>"><?php echo $success; ?></p>
    <?php endif; ?>
    <form method="POST">
      <label>Staff ID</label>
      <input type="text" name="staff_id" required>

      <label>Full Name</label>
      <input type="text" name="full_name" required>

      <label>Designation / Role</label>
      <select name="role" required>
        <option value="">--Select Role--</option>
        <option value="Dentist">Dentist</option>
        <option value="Hygienist">Hygienist</option>
        <option value="Assistant">Assistant</option>
        <option value="Coordinator">Coordinator</option>
      </select>

      <label>Department</label>
      <input type="text" name="department" required>

      <label>Contact Number</label>
      <input type="text" name="contact" required>

      <label>Email Address</label>
      <input type="email" name="email" required>

      <label>Date of Joining</label>
      <input type="date" name="doj" required>

      <label>Work Location</label>
      <input type="text" name="location" required>

      <label>Salary</label>
      <input type="number" name="salary" step="0.01" required>

      <button type="submit">Submit</button>
    </form>
  </div>
</body>
</html>
