<?php
date_default_timezone_set('Asia/Kolkata'); // set to your local timezone

// Example: You can later replace with actual session-based name
$staffName = "HR Team";

// Get current hour
$hour = date('H');

if ($hour >= 5 && $hour < 12) {
    $greeting = "Good Morning";
} elseif ($hour >= 12 && $hour < 17) {
    $greeting = "Good Afternoon";
} elseif ($hour >= 17 && $hour < 21) {
    $greeting = "Good Evening";
} else {
    $greeting = "Good Night";
}

// Random quote list
$quotes = [
    "Success usually comes to those who are too busy to be looking for it. – Henry David Thoreau",
    "Don't watch the clock; do what it does. Keep going. – Sam Levenson",
    "Hard work beats talent when talent doesn't work hard. – Tim Notke",
    "Quality means doing it right when no one is looking. – Henry Ford",
    "The future depends on what you do today. – Mahatma Gandhi"
];

// Pick a random quote
$quoteOfTheDay = $quotes[array_rand($quotes)];
?>

<!DOCTYPE html>
<html>
<head>
  <title>HR Dashboard</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      padding: 30px;
      background-color: #f9f9f9;
    }

    .welcome-box {
      background-color: #ffffff;
      border-left: 6px solid #3498db;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
    }

    .welcome-box h2 {
      margin: 0 0 10px 0;
      color: #2c3e50;
    }

    .welcome-box p {
      font-size: 16px;
      color: #555;
    }

    .quote {
      margin-top: 20px;
      font-style: italic;
      color: #7f8c8d;
    }
  </style>
</head>
<body>

  <div class="welcome-box">
    <h2><?= $greeting ?>, <?= $staffName ?>! 👋</h2>
    <p>Welcome to the Staff Dashboard. Hope you're having a great day!</p>
    <p class="quote">“<?= $quoteOfTheDay ?>”</p>
  </div>

</body>
</html>
