<?php
// Embedded config.php - Database connection
$host = "localhost";
$user = "primaria_dental";
$password = "Olympics@2028";
$database = "primaria_dental";
$conn = new mysqli($host, $user, $password, $database);
if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_all'])) {
  // 1. Insert into dental_camp
  $stmt = $conn->prepare(
    "INSERT INTO dental_camp (camp_name, camp_location, camp_date, camp_coordinator) VALUES (?, ?, ?, ?)"
  );
  $stmt->bind_param("ssss", $_POST['camp_name'], $_POST['camp_location'], $_POST['camp_date'], $_POST['camp_coordinator']);
  $stmt->execute();
  $camp_id = $stmt->insert_id;
  $stmt->close();

  // 2. Staff
  foreach ($_POST['staff_name'] as $i => $name) {
    if (trim($name) === '') continue;
    $stmt = $conn->prepare("INSERT INTO camp_staff (camp_id, staff_name, role, contact_number) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("isss", $camp_id, $name, $_POST['staff_role'][$i], $_POST['staff_contact'][$i]);
    $stmt->execute();
    $stmt->close();
  }

  // 3. Patients
  $follow_yes = ($_POST['follow_up_recommended'] === 'Yes') ? 1 : 0;
  $stmt = $conn->prepare("INSERT INTO camp_patients (camp_id, total_screened, appointments_booked, follow_up_recommended, follow_up_count) VALUES (?, ?, ?, ?, ?)");
  $stmt->bind_param("iiiii", $camp_id, $_POST['total_screened'], $_POST['appointments_booked'], $follow_yes, $_POST['follow_up_count']);
  $stmt->execute();
  $stmt->close();

  // 4. Equipment
  foreach ($_POST['equip_name'] as $i => $eqname) {
    if (trim($eqname) === '') continue;
    $stmt = $conn->prepare("INSERT INTO camp_equipment (camp_id, equipment_name, quantity_used, remarks) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("isis", $camp_id, $eqname, $_POST['equip_qty'][$i], $_POST['equip_remarks'][$i]);
    $stmt->execute();
    $stmt->close();
  }

  // 5. Consumables
  foreach ($_POST['cons_name'] as $i => $cname) {
    if (trim($cname) === '') continue;
    $stmt = $conn->prepare("INSERT INTO camp_consumables (camp_id, item_name, quantity_used, remarks) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("isss", $camp_id, $cname, $_POST['cons_qty'][$i], $_POST['cons_remarks'][$i]);
    $stmt->execute();
    $stmt->close();
  }

  // 6. Allowances
  foreach ($_POST['ta_name'] as $i => $aname) {
    if (trim($aname) === '') continue;
    $stmt = $conn->prepare("INSERT INTO camp_allowances (camp_id, name, role, travel_allowance, daily_allowance, payment_status) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("issdds", $camp_id, $aname, $_POST['ta_role'][$i], $_POST['travel_allowance'][$i], $_POST['daily_allowance'][$i], $_POST['payment_status'][$i]);
    $stmt->execute();
    $stmt->close();
  }

  // 7. Notes
  $stmt = $conn->prepare("INSERT INTO camp_notes (camp_id, notes) VALUES (?, ?)");
  $stmt->bind_param("is", $camp_id, $_POST['additional_notes']);
  $stmt->execute();
  $stmt->close();

  // Redirect
  header("Location: dental_camp_data_entry.php?success=1");
  exit;
}

$steps = ['Camp Details', 'Staff Details', 'Patient Data', 'Equipment Used', 'Consumables Used', 'T.A. & D.A.', 'Notes'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Dental Camp Data Entry</title>
  <style>
    body { font-family: Arial, sans-serif; background: #f5f5f5; margin:0; padding:20px; }
    #regForm { background:#fff; padding:40px; border-radius:8px; max-width:800px; margin:auto; box-shadow:0 2px 8px rgba(0,0,0,0.1); }
    h1 { text-align:center; }
    .tab { display:none; }
    button { background:#3498db; color:#fff; border:none; padding:10px 20px; border-radius:4px; cursor:pointer; }
    button:hover { background:#2980b9; }
    #prevBtn { background:#ccc; color:#333; }
    input, select, textarea { width:100%; padding:10px; margin:6px 0 20px; border:1px solid #ccc; border-radius:4px; }
    .step { width:15px; height:15px; margin:0 2px; background:#bbb; border-radius:50%; display:inline-block; }
    .step.active { background:#3498db; }
    .step.finish { background:#2ecc71; }
    .success-msg { background:#2ecc71; color:#fff; padding:10px; border-radius:5px; text-align:center; margin-bottom:20px; }
    .array-group { display:flex; flex-wrap:wrap; gap:10px; }
    .array-item { flex:1 1 45%; background:#f9f9f9; padding:10px; border-radius:4px; border:1px solid #eee; }
  </style>
</head>
<body>
  <form id="regForm" method="POST">
    <h1>🦷 Dental Camp Entry</h1>

    <?php if (isset($_GET['success']) && $_GET['success'] == 1): ?>
      <div class="success-msg">✅ Data submitted successfully!</div>
    <?php endif; ?>

    <?php foreach($steps as $i=>$step): ?>
    <div class="tab">
      <h3><?php echo $step ?></h3>
      <?php if ($i === 0): ?>
        <label>Camp Name</label><input name="camp_name" required>
        <label>Camp Location</label><input name="camp_location" required>
        <label>Date of Camp</label><input type="date" name="camp_date" required>
        <label>Camp Coordinator Name</label><input name="camp_coordinator" required>
      <?php elseif ($i === 1): ?>
        <div id="staffGroup" class="array-group">
          <div class="array-item">
            <label>Staff Name</label><input name="staff_name[]" required>
            <label>Role</label><input name="staff_role[]" required>
            <label>Contact Number</label><input name="staff_contact[]" required>
          </div>
        </div>
        <button type="button" onclick="addStaff()">+ Add Staff</button>
      <?php elseif ($i === 2): ?>
        <label>Total Number of Patients Screened</label><input type="number" name="total_screened" required>
        <label>Appointments Booked</label><input type="number" name="appointments_booked" required>
        <label>Follow-up Recommended?</label>
        <select name="follow_up_recommended" id="follow_up_recommended" onchange="autoSetFollowUpCount()">
          <option>Yes</option><option>No</option>
        </select>
        <label>Follow-up Count</label><input type="number" name="follow_up_count" id="follow_up_count" required>
      <?php elseif ($i === 3): ?>
        <div id="equipGroup" class="array-group">
          <div class="array-item">
            <label>Equipment Name</label><input name="equip_name[]" required>
            <label>Quantity Used</label><input type="number" name="equip_qty[]" required>
            <label>Remarks</label><textarea name="equip_remarks[]"></textarea>
          </div>
        </div>
        <button type="button" onclick="addEquip()">+ Add Equipment</button>
      <?php elseif ($i === 4): ?>
        <div id="consGroup" class="array-group">
          <div class="array-item">
            <label>Item Name</label><input name="cons_name[]" required>
            <label>Quantity Used</label><input name="cons_qty[]" required>
            <label>Remarks</label><textarea name="cons_remarks[]"></textarea>
          </div>
        </div>
        <button type="button" onclick="addCons()">+ Add Consumable</button>
      <?php elseif ($i === 5): ?>
        <div id="taGroup" class="array-group">
          <div class="array-item">
            <label>Name</label><input name="ta_name[]" required>
            <label>Role</label><input name="ta_role[]" required>
            <label>Travel Allowance</label><input type="number" step="0.01" name="travel_allowance[]" required>
            <label>Daily Allowance</label><input type="number" step="0.01" name="daily_allowance[]" required>
            <label>Payment Status</label>
            <select name="payment_status[]">
              <option>Paid</option><option>Pending</option>
            </select>
          </div>
        </div>
        <button type="button" onclick="addTA()">+ Add TA</button>
      <?php else: ?>
        <label>Notes</label><textarea name="additional_notes" rows="5"></textarea>
      <?php endif; ?>
    </div>
    <?php endforeach; ?>

    <div style="overflow:auto;">
      <div style="float:right;">
        <button type="button" id="prevBtn" onclick="nextPrev(-1)">Previous</button>
        <button type="button" id="nextBtn" onclick="nextPrev(1)">Next</button>
      </div>
    </div>
    <div style="text-align:center; margin-top:20px;">
      <?php foreach($steps as $_): ?><span class="step"></span><?php endforeach; ?>
    </div>
    <input type="hidden" name="submit_all" value="1">
  </form>

  <script>
    let currentTab = 0;
    showTab(currentTab);

    function showTab(n) {
      const tabs = document.getElementsByClassName("tab");
      tabs[n].style.display = "block";
      document.getElementById("prevBtn").style.display = n === 0 ? "none" : "inline";
      document.getElementById("nextBtn").innerHTML = n === (tabs.length - 1) ? "Submit" : "Next";
      fixStepIndicator(n);
    }

    function nextPrev(n) {
      const tabs = document.getElementsByClassName("tab");
      if (n === 1 && !validateForm()) return false;
      tabs[currentTab].style.display = "none";
      currentTab += n;
      if (currentTab >= tabs.length) {
        document.getElementById("regForm").submit();
        return false;
      }
      showTab(currentTab);
    }

    function validateForm() {
      let valid = true;
      const inputs = document.getElementsByClassName("tab")[currentTab].getElementsByTagName("input");
      for (let i = 0; i < inputs.length; i++) {
        if (inputs[i].hasAttribute("required") && inputs[i].value == "") {
          inputs[i].className += " invalid";
          valid = false;
        }
      }
      return valid;
    }

    function fixStepIndicator(n) {
      const steps = document.getElementsByClassName("step");
      for (let i = 0; i < steps.length; i++) steps[i].className = steps[i].className.replace(" active", "");
      steps[n].className += " active";
    }

    function autoSetFollowUpCount() {
      const followUp = document.getElementById('follow_up_recommended');
      const count = document.getElementById('follow_up_count');
      if (followUp.value === 'No') {
        count.value = 0;
        count.readOnly = true;
      } else {
        count.readOnly = false;
      }
    }

    function addGroup(id, html) {
      document.getElementById(id).insertAdjacentHTML('beforeend', html);
    }
    function addStaff() { addGroup('staffGroup', document.querySelector('#staffGroup .array-item').outerHTML); }
    function addEquip() { addGroup('equipGroup', document.querySelector('#equipGroup .array-item').outerHTML); }
    function addCons() { addGroup('consGroup', document.querySelector('#consGroup .array-item').outerHTML); }
    function addTA() { addGroup('taGroup', document.querySelector('#taGroup .array-item').outerHTML); }
  </script>
</body>
</html>
